/*QuickView*/
(function ($) {
	"use strict";
	var WidgetProQCWHandler = function($scope, $) {
		var qvwrap = $scope.find('.tp-quick-view-wrap');
		
		if(qvwrap.length){
            jQuery(qvwrap).on("click", function(event){
                event.preventDefault();
                var product_id = $(this).data('product-id'),
                    customtemplate = $scope.find('.product-list').data("customtemplateqcw"),
                    template = $scope.find('.product-list').data("templateqcw");
                
                if(product_id !== undefined){
                    jQuery.ajax({
                        type: 'POST',
                        url: theplus_ajax_url,							
                        data :{
                            'action': 'tp_get_product_ajax',
                            'product_id':  product_id,
                            'custom_template':  customtemplate,
                            'template_id' : template,
                            'status': 'publish',
                            'security' : theplus_nonce,			 
                        }, 
                        success:function(response){	
                            $.fancybox.open(response);
                            $('.tp-pro-view-spinner').remove();
                            $('.tpqvactive').css('display','block').removeClass('tpqvactive');								
                        }
                    });
                }
                
                $(this).find('i').addClass('tpqvactive').css('display','none');
                $(this).find('svg').addClass('tpqvactive').css('display','none');
                $(this).append('<div class="tp-pro-view-spinner"></div>');
            });
		}
	};	
	
	$(window).on('elementor/frontend/init', function () {
		elementorFrontend.hooks.addAction('frontend/element_ready/tp-product-listout.default', WidgetProQCWHandler);
	});
})(jQuery);